{ *********************************************************************** }
{                                                                         }
{ Translated Header File                                                  }
{ Part of the Delphi Visual Component Library                             }
{                                                                         }
{ Original Header File Copyright (c) 1985-2004 Microsoft Corporation      }
{  All Rights Reserved.                                                   }
{                                                                         }
{ Translation Copyright (c) 1995-2004 Borland Software Corporation        }
{                                                                         }
{ *********************************************************************** }

unit Borland.Vcl.DDEml platform;

interface

uses Windows, System.Runtime.InteropServices, System.Text;

type
  HConvList = Longint;
  HConv = Longint;
  HSz = Longint;
  HDDEData = Longint;

type
  { the following structure is for use with xtyp_WildConnect processing. }
  [StructLayout(LayoutKind.Sequential)]
  tagHSZPAIR = record
    hszSvc: HSZ;
    hszTopic: HSZ;
  end;
  THSZPair = tagHSZPAIR;
  HSZPAIR = tagHSZPAIR;

  { The following structure is used by DdeConnect() and DdeConnectList()
    and by xtyp_Connect and xtyp_WildConnect callbacks. }

  [StructLayout(LayoutKind.Sequential)]
  tagCONVCONTEXT = record
    cb: UINT;            { set to sizeof(ConvCOnTEXT) }
    wFlags: UINT;        { none currently defined. }
    wCountryID: UINT;    { country code for topic/item strings used. }
    iCodePage: Integer;  { codepage used for topic/item strings. }
    dwLangID: DWORD;     { language ID for topic/item strings. }
    dwSecurity: DWORD;   { Private security code. }
    qos: TSecurityQualityOfService;  { used to support client impersonation }
  end;
  TConvContext = tagCONVCONTEXT;
  CONVCONTEXT = tagCONVCONTEXT;

{ The following structure is used by DdeQueryConvInfo(): }

  [StructLayout(LayoutKind.Sequential)]
  tagCONVINFO = record
    cb: DWORD;            { sizeof(CONVINFO)  }
    hUser: DWORD;         { user specified field  }
    hConvPartner: HConv;    { hConv on other end or 0 if non-ddemgr partner  }
    hszSvcPartner: HSz;     { app name of partner if obtainable  }
    hszServiceReq: HSz;     { AppName requested for connection  }
    hszTopic: HSz;          { Topic name for conversation  }
    hszItem: HSz;           { transaction item name or NULL if quiescent  }
    wFmt: UINT;             { transaction format or NULL if quiescent  }
    wType: UINT;            { XTYP_ for current transaction  }
    wStatus: UINT;          { ST_ constant for current conversation  }
    wConvst: UINT;          { XST_ constant for current transaction  }
    wLastError: UINT;       { last transaction error.  }
    hConvList: HConvList;   { parent hConvList if this conversation is in a list }
    ConvCtxt: TConvContext; { conversation context }
    hwnd: HWND;             { window handle for this conversation }
    hwndPartner: HWND;      { partner window handle for this conversation }
  end;
  TConvInfo = tagCONVINFO;
  CONVINFO = tagCONVINFO;

const
  { conversation states (usState) }

  XST_NULL = 0;                 { quiescent states }
  XST_INCOMPLETE = 1;
  XST_CONNECTED = 2;
  XST_INIT1 = 3;                { mid-initiation states }
  XST_INIT2 = 4;
  XST_REQSENT = 5;              { active conversation states }
  XST_DATARCVD = 6;
  XST_POKESENT = 7;
  XST_POKEACKRCVD = 8;
  XST_EXECSENT = 9;
  XST_EXECACKRCVD = 10;
  XST_ADVSENT = 11;
  XST_UNADVSENT = 12;
  XST_ADVACKRCVD = 13;
  XST_UNADVACKRCVD = 14;
  XST_ADVDATASENT = 15;
  XST_ADVDATAACKRCVD = 16;

  { used in LOWORD(dwData1) of XTYP_ADVREQ callbacks... }

  CADV_LATEACK = $FFFF;

  { conversation status bits (fsStatus) }

  ST_CONNECTED = $0001;
  ST_ADVISE = $0002;
  ST_ISLOCAL = $0004;
  ST_BLOCKED = $0008;
  ST_CLIENT = $0010;
  ST_TERMINATED = $0020;
  ST_INLIST = $0040;
  ST_BLOCKNEXT = $0080;
  ST_ISSELF = $0100;

  { DDE constants for wStatus field }

  DDE_FACK = $8000;
  DDE_FBUSY = $4000;
  DDE_FDEFERUPD = $4000;
  DDE_FACKREQ = $8000;
  DDE_FRELEASE = $2000;
  DDE_FREQUESTED = $1000;
  DDE_FAPPSTATUS = $00ff;
  DDE_FNOTPROCESSED = $0000;

  DDE_FACKRESERVED = $3ff0;
  DDE_FADVRESERVED = $3fff;
  DDE_FDATRESERVED = $4fff;
  DDE_FPOKRESERVED = $dfff;

  { message filter hook types }

  MSGF_DDEMGR = $8001;

  { default codepage for windows & old DDE convs. }

  CP_WINANSI = 1004;
  CP_WINUNICODE = 1200;


	CP_WINNEUTRAL = CP_WINANSI;

  { transaction types }

  XTYPF_NOBLOCK = $0002; { CBR_BLOCK will not work }
  XTYPF_NODATA = $0004;  { DDE_FDEFERUPD }
  XTYPF_ACKREQ = $0008;  { DDE_FACKREQ }

  XCLASS_MASK = $FC00;
  XCLASS_BOOL = $1000;
  XCLASS_DATA = $2000;
  XCLASS_FLAGS = $4000;
  XCLASS_NOTIFICATION = $8000;

  XTYP_ERROR = $0000 or XCLASS_NOTIFICATION or XTYPF_NOBLOCK;
  XTYP_ADVDATA = $0010 or XCLASS_FLAGS;
  XTYP_ADVREQ = $0020 or XCLASS_DATA or XTYPF_NOBLOCK;
  XTYP_ADVSTART = $0030 or XCLASS_BOOL;
  XTYP_ADVSTOP = $0040 or XCLASS_NOTIFICATION;
  XTYP_EXECUTE = $0050 or XCLASS_FLAGS;
  XTYP_CONNECT = $0060 or XCLASS_BOOL or XTYPF_NOBLOCK;
  XTYP_CONNECT_CONFIRM = $0070 or XCLASS_NOTIFICATION or XTYPF_NOBLOCK;
  XTYP_XACT_COMPLETE = $0080 or XCLASS_NOTIFICATION;
  XTYP_POKE = $0090 or XCLASS_FLAGS;
  XTYP_REGISTER = $00A0 or XCLASS_NOTIFICATION or XTYPF_NOBLOCK;
  XTYP_REQUEST = $00B0 or XCLASS_DATA;
  XTYP_DISCONNECT = $00C0 or XCLASS_NOTIFICATION or XTYPF_NOBLOCK;
  XTYP_UNREGISTER = $00D0 or XCLASS_NOTIFICATION or XTYPF_NOBLOCK;
  XTYP_WILDCONNECT = $00E0 or XCLASS_DATA or XTYPF_NOBLOCK;

  XTYP_MASK = $00F0;
  XTYP_SHIFT = 4;  { shift to turn xtyp_ into an index }

  { Timeout constants }

  TIMEOUT_ASYNC =           DWORD(-1);

  { Transaction ID constatnts }
  QID_SYNC =                DWORD(-1);

  { public strings used in DDE }

  SZDDESYS_TOPIC = 'System';
  SZDDESYS_ITEM_TOPICS = 'Topics';
  SZDDESYS_ITEM_SYSITEMS = 'SysItems';
  SZDDESYS_ITEM_RTNMSG = 'ReturnMessage';
  SZDDESYS_ITEM_STATUS = 'Status';
  SZDDESYS_ITEM_FORMATS = 'Formats';
  SZDDESYS_ITEM_HELP = 'Help';
  SZDDE_ITEM_ITEMLIST = 'TopicItemList';

type
  { API entry points }
  PFNCALLBACK = function (CallType, Fmt: UINT; Conv: HConv; hsz1, hsz2: HSZ;
    Data: HDDEData; Data1, Data2: DWORD): HDDEData;
  TFNCallback = PFNCALLBACK;

const
  CBR_BLOCK = $FFFFFFFF;

{ DLL registration functions }

function DdeInitializeA(var Inst: Longint; Callback: TFNCallback;
  Cmd, Res: Longint): Longint;
function DdeInitializeW(var Inst: Longint; Callback: TFNCallback;
  Cmd, Res: Longint): Longint;
function DdeInitialize(var Inst: Longint; Callback: TFNCallback;
  Cmd, Res: Longint): Longint;

const
  { Callback filter flags for use with standard apps. }

  CBF_FAIL_SELFCONNECTIONS = $00001000;
  CBF_FAIL_CONNECTIONS = $00002000;
  CBF_FAIL_ADVISES = $00004000;
  CBF_FAIL_EXECUTES = $00008000;
  CBF_FAIL_POKES = $00010000;
  CBF_FAIL_REQUESTS = $00020000;
  CBF_FAIL_ALLSVRXACTIONS = $0003f000;

  CBF_SKIP_CONNECT_CONFIRMS = $00040000;
  CBF_SKIP_REGISTRATIONS = $00080000;
  CBF_SKIP_UNREGISTRATIONS = $00100000;
  CBF_SKIP_DISCONNECTS = $00200000;
  CBF_SKIP_ALLNOTIFICATIONS = $003c0000;

  { Application command flags }

  APPCMD_CLIENTONLY = $00000010;
  APPCMD_FILTERINITS = $00000020;
  APPCMD_MASK = $00000FF0;

  { Application classification flags }

  APPCLASS_STANDARD = $00000000;
  APPCLASS_MASK = $0000000F;

function DdeUninitialize(Inst: DWORD): BOOL;

{ conversation enumeration functions }

function DdeConnectList(Inst: DWORD; Service, Topic: HSZ;
  ConvList: HConvList; const CC: TConvContext): HConvList; overload;
function DdeConnectList(Inst: DWORD; Service, Topic: HSZ;
  ConvList: HConvList; CC: IntPtr): HConvList; overload;
function DdeQueryNextServer(ConvList: HConvList; ConvPrev: HConv): HConv;
function DdeDisconnectList(ConvList: HConvList): BOOL;

{ conversation control functions }

function DdeConnect(Inst: DWORD; Service, Topic: HSZ;
  const CC: TConvContext): HConv; overload;
function DdeConnect(Inst: DWORD; Service, Topic: HSZ;
  CC: IntPtr): HConv; overload;
function DdeDisconnect(Conv: HConv): BOOL;
function DdeReconnect(Conv: HConv): HConv;

function DdeQueryConvInfo(Conv: HConv; Transaction: DWORD;
 var ConvInfo: TConvInfo): UINT;
function DdeSetUserHandle(Conv: HConv; ID, User: DWORD): BOOL;

function DdeAbandonTransaction(Inst: DWORD; Conv: HConv;
  Transaction: DWORD): BOOL;

{ app server interface functions }

function DdePostAdvise(Inst: DWORD; Topic, Item: HSZ): BOOL;
function DdeEnableCallback(Inst: DWORD; Conv: HConv; Cmd: UINT): BOOL;

const
  EC_ENABLEALL = 0;
  EC_ENABLEONE = ST_BLOCKNEXT;
  EC_DISABLE = ST_BLOCKED;
  EC_QUERYWAITING = 2;

function DdeNameService(Inst: DWORD; hsz1, hsz2: HSZ; Cmd: UINT): HDDEData;

const
  DNS_REGISTER = $0001;
  DNS_UNREGISTER = $0002;
  DNS_FILTERON = $0004;
  DNS_FILTEROFF = $0008;

{ app client interface functions }

function DdeClientTransaction(Data: IntPtr; DataLen: DWORD;
  Conv: HConv; Item: HSZ; Fmt, DataType: UINT; Timeout: DWORD;
  out Result: DWORD): HDDEData; overload;
function DdeClientTransaction(Data: HDDEData; DataLen: DWORD;
  Conv: HConv; Item: HSZ; Fmt, DataType: UINT; Timeout: DWORD;
  out Result: DWORD): HDDEData; overload;

{ data transfer functions }

function DdeCreateDataHandle(Inst: DWORD; Src: IntPtr;
  cb, Off: DWORD; Item: HSZ; Fmt, Cmd: UINT): HDDEData;

function DdeAddData(Data: HDDEData; Src: IntPtr;
  cb, Off: DWORD): HDDEData;
function DdeGetData(Data: HDDEData; Dst: IntPtr;
  Max, Off: DWORD): DWORD;
function DdeAccessData(Data: HDDEData; out DataSize: DWORD): IntPtr;
function DdeUnaccessData(Data: HDDEData): BOOL;
function DdeFreeDataHandle(Data: HDDEData): BOOL;

const
  HDATA_APPOWNED = $0001;

function DdeGetLastError(Inst: DWORD): UINT;

const
  { error codes }

  DMLERR_NO_ERROR = 0;       { must be 0 }

  DMLERR_FIRST = $4000;

  DMLERR_ADVACKTIMEOUT = $4000;
  DMLERR_BUSY = $4001;
  DMLERR_DATAACKTIMEOUT = $4002;
  DMLERR_DLL_NOT_INITIALIZED = $4003;
  DMLERR_DLL_USAGE = $4004;
  DMLERR_EXECACKTIMEOUT = $4005;
  DMLERR_INVALIDPARAMETER = $4006;
  DMLERR_LOW_MEMORY = $4007;
  DMLERR_MEMORY_ERROR = $4008;
  DMLERR_NOTPROCESSED = $4009;
  DMLERR_NO_CONV_ESTABLISHED = $400a;
  DMLERR_POKEACKTIMEOUT = $400b;
  DMLERR_POSTMSG_FAILED = $400c;
  DMLERR_REENTRANCY = $400D;
  DMLERR_SERVER_DIED = $400E;
  DMLERR_SYS_ERROR = $400F;
  DMLERR_UNADVACKTIMEOUT = $4010;
  DMLERR_UNFOUND_QUEUE_ID = $4011;

  DMLERR_LAST = $4011;

function DdeCreateStringHandleA(Inst: DWORD; psz: string;
  CodePage: Integer): HSZ;
function DdeCreateStringHandleW(Inst: DWORD; psz: string;
  CodePage: Integer): HSZ;
function DdeCreateStringHandle(Inst: DWORD; psz: string;
  CodePage: Integer): HSZ;
function DdeQueryStringA(Inst: DWORD; HSZ: HSZ; psz: StringBuilder;
  Max: DWORD; CodePage: Integer): DWORD;
function DdeQueryStringW(Inst: DWORD; HSZ: HSZ; psz: StringBuilder;
  Max: DWORD; CodePage: Integer): DWORD;
function DdeQueryString(Inst: DWORD; HSZ: HSZ; psz: StringBuilder;
  Max: DWORD; CodePage: Integer): DWORD;
function DdeFreeStringHandle(Inst: DWORD; HSZ: HSZ): BOOL;
function DdeKeepStringHandle(Inst: DWORD; HSZ: HSZ): BOOL;
function DdeCmpStringHandles(hsz1, hsz2: HSZ): Integer;

type
  { DDEML public debugging header file info }

  tagDDEML_MSG_HOOK_DATA = packed record  { new for NT }
    uiLo: UINT;      { unpacked lo and hi parts of lParam }
    uiHi: UINT;
    cbData: DWORD;   { amount of data in message, if any. May be > than 32 bytes. }
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=8)]
    Data: array [0..7] of DWORD; { data peeking by DDESPY is limited to 32 bytes. }
  end;
  TDdemlMsgHookData = tagDDEML_MSG_HOOK_DATA;
  DDEML_MSG_HOOK_DATA = tagDDEML_MSG_HOOK_DATA;

  tagMONMSGSTRUCT = packed record
    cb: UINT;
    hWndTo: HWND;
    dwTime: DWORD;
    hTask: THandle;
    wMsg: UINT;
    wParam: WPARAM;
    lParam: LPARAM;
    dmhd: TDdemlMsgHookData;
  end;
  TMonMsgStruct = tagMONMSGSTRUCT;
  MONMSGSTRUCT = tagMONMSGSTRUCT;

  tagMONCBSTRUCT = packed record
    cb: UINT;
    dwTime: DWORD;
    hTask: THandle;
    dwRet: DWORD;
    wType: UINT;
    wFmt: UINT;
    hConv: HConv;
    hsz1: HSZ;
    hsz2: HSZ;
    hData: HDDEData;
    dwData1: DWORD;
    dwData2: DWORD;
    cc: TConvContext;  { new for NT for XTYP_CONNECT callbacks }
    cbData: DWORD;     { new for NT for data peeking }
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=8)]
    Data: array [0..7] of DWORD; { new for NT for data peeking }
  end;
  TMonCBStruct = tagMONCBSTRUCT;
  MONCBSTRUCT = tagMONCBSTRUCT;

  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMONHSZSTRUCT = record
    cb: UINT;
    fsAction: BOOL;    { mh_ value }
    dwTime: DWORD;
    HSZ: HSZ;
    hTask: THandle;
    wReserved: UINT;
    Str: IntPtr; {array[0..0] of Char;}
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMONHSZSTRUCTA = record
    cb: UINT;
    fsAction: BOOL;    { mh_ value }
    dwTime: DWORD;
    HSZ: HSZ;
    hTask: THandle;
    wReserved: UINT;
    Str: IntPtr; {array[0..0] of AnsiChar;}
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMONHSZSTRUCTW = record
    cb: UINT;
    fsAction: BOOL;    { mh_ value }
    dwTime: DWORD;
    HSZ: HSZ;
    hTask: THandle;
    wReserved: UINT;
    Str: IntPtr; {array[0..0] of WideChar; }
  end;
  TMonHSZStructA = tagMONHSZSTRUCTA;
  TMonHSZStructW = tagMONHSZSTRUCTW;
  TMonHSZStruct = tagMONHSZSTRUCT;
  MONHSZSTRUCTA = tagMONHSZSTRUCTA;
  MONHSZSTRUCTW = tagMONHSZSTRUCTW;
  MONHSZSTRUCT = tagMONHSZSTRUCT;

const
  MH_CREATE = 1;
  MH_KEEP = 2;
  MH_DELETE = 3;
  MH_CLEANUP = 4;

type
  tagMONERRSTRUCT = packed record
    cb: UINT;
    wLastError: UINT;
    dwTime: DWORD;
    hTask: THandle;
  end;
  TMonErrStruct = tagMONERRSTRUCT;
  MONERRSTRUCT = tagMONERRSTRUCT;

  tagMONLINKSTRUCT = packed record
    cb: UINT;
    dwTime: DWORD;
    hTask: THandle;
    fEstablished: BOOL;
    fNoData: BOOL;
    hszSvc: HSz;
    hszTopic: HSz;
    hszItem: HSz;
    wFmt: UINT;
    fServer: BOOL;
    hConvServer: HConv;
    hConvClient: HConv;
  end;
  TMonLinkStruct = tagMONLINKSTRUCT;
  MONLINKSTRUCT = tagMONLINKSTRUCT;

  tagMONCONVSTRUCT = packed record
    cb: UINT;
    fConnect: BOOL;
    dwTime: DWORD;
    hTask: THandle;
    hszSvc: HSz;
    hszTopic: HSz;
    hConvClient: HConv;
    hConvServer: HConv;
  end;
  TMonConvStruct = tagMONCONVSTRUCT;
  MONCONVSTRUCT = tagMONCONVSTRUCT;

const
  MAX_MONITORS = 4;
  APPCLASS_MONITOR = 1;
  XTYP_MONITOR = $00F0 or XCLASS_NOTIFICATION or XTYPF_NOBLOCK;

{ Callback filter flags for use with MONITOR apps - 0 implies no monitor
  callbacks. }

const
  MF_HSZ_INFO = $01000000;
  MF_SENDMSGS = $02000000;
  MF_POSTMSGS = $04000000;
  MF_CALLBACKS = $08000000;
  MF_ERRORS = $10000000;
  MF_LINKS = $20000000;
  MF_CONV = $40000000;

  ddelib = 'user32.dll';

implementation

[DllImport(ddelib, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DdeInitializeA')]
function DdeInitializeA; external;
[DllImport(ddelib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DdeInitializeW')]
function DdeInitializeW; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeInitialize')]
function DdeInitialize; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeUninitialize')]
function DdeUninitialize; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeConnectList')]
function DdeConnectList(Inst: DWORD; Service, Topic: HSZ;
  ConvList: HConvList; const CC: TConvContext): HConvList; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeConnectList')]
function DdeConnectList(Inst: DWORD; Service, Topic: HSZ;
  ConvList: HConvList; CC: IntPtr): HConvList; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeQueryNextServer')]
function DdeQueryNextServer; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeDisconnectList')]
function DdeDisconnectList; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeConnect')]
function DdeConnect(Inst: DWORD; Service, Topic: HSZ;
  const CC: TConvContext): HConv; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeConnect')]
function DdeConnect(Inst: DWORD; Service, Topic: HSZ;
  CC: IntPtr): HConv; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeDisconnect')]
function DdeDisconnect; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeReconnect')]
function DdeReconnect; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeQueryConvInfo')]
function DdeQueryConvInfo; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeSetUserHandle')]
function DdeSetUserHandle; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeAbandonTransaction')]
function DdeAbandonTransaction; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdePostAdvise')]
function DdePostAdvise; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeEnableCallback')]
function DdeEnableCallback; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeNameService')]
function DdeNameService; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeClientTransaction')]
function DdeClientTransaction(Data: IntPtr; DataLen: DWORD;
  Conv: HConv; Item: HSZ; Fmt, DataType: UINT; Timeout: DWORD;
  out Result: DWORD): HDDEData; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeClientTransaction')]
function DdeClientTransaction(Data: HDDEData; DataLen: DWORD;
  Conv: HConv; Item: HSZ; Fmt, DataType: UINT; Timeout: DWORD;
  out Result: DWORD): HDDEData; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeCreateDataHandle')]
function DdeCreateDataHandle; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeAddData')]
function DdeAddData; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeGetData')]
function DdeGetData; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeAccessData')]
function DdeAccessData; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeUnaccessData')]
function DdeUnaccessData; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeFreeDataHandle')]
function DdeFreeDataHandle; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeGetLastError')]
function DdeGetLastError; external;
[DllImport(ddelib, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DdeCreateStringHandleA')]
function DdeCreateStringHandleA; external;
[DllImport(ddelib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DdeCreateStringHandleW')]
function DdeCreateStringHandleW; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeCreateStringHandle')]
function DdeCreateStringHandle; external;
[DllImport(ddelib, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DdeQueryStringA')]
function DdeQueryStringA; external;
[DllImport(ddelib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DdeQueryStringW')]
function DdeQueryStringW; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeQueryString')]
function DdeQueryString; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeFreeStringHandle')]
function DdeFreeStringHandle; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeKeepStringHandle')]
function DdeKeepStringHandle; external;
[DllImport(ddelib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DdeCmpStringHandles')]
function DdeCmpStringHandles; external;
end.
